* For reference, we include here two CEM procedures. We start from a panel in long form and end up with a panel in a long form
* For Tables in the papers we have run other CEM procedures which are available upon request.
**************************************************************************************************************
**************************************************************************************************************
**************************************************************************************************************
**************************************************************************************************************
**** MATCH BASED ON  CITES_WINDOW_TOT AND CITES_PRE-TOTAL-2000-2008 *****

cd D:\P_ABS\Stata
use Final_Panel_Baseline1, clear
bysort eid: egen sum1=sum(CitesUKNet)
drop if sum1==0
keep if sum1<100
keep eid  year citingyear winner  CitesUKNet
reshape wide CitesUKNet, i(eid) j(citingyear)
forvalues i=1993(1)2018 {
replace CitesUKNet`i' = 0 if CitesUKNet`i' ==.
}
gen CITESALL 	= CitesUKNet2000 + CitesUKNet2001 + CitesUKNet2002 + CitesUKNet2003 + 	CitesUKNet2004 + 	CitesUKNet2005 + 	CitesUKNet2006 + 	CitesUKNet2007 + 	CitesUKNet2008 
gen CITES_WIN 	= CitesUKNet2009+CitesUKNet2010+CitesUKNet2011+CitesUKNet2012
sort winner eid
bysort winner: gen jj=_n
bysort winner: sum jj
codebook eid if winner==1
sum CITESALL CITES_WIN, de
sort eid
save TTTEMP, replace


forvalues i=1(1)3665 {
quietly use TTTEMP, clear
quietly keep if (winner==1 & jj==`i') | winner==0
gen y1 =year if winner==1
egen y2=min(y1)
keep if y2==year
drop y1 y2

cem   CITESALL (0 0.01 1 2 4 13) CITES_WIN (0 0.01 1 3 9) , treatment(winner)   k2k showbreaks
quietly keep if cem_matched==1
drop cem_str cem_weigh jj 
reshape long CitesUKNet, i(eid) j(citingyear)
keep if citingyear>=year
gen KK=`i'
quietly save ttt`i', replace
}

use ttt1, clear
quietly forvalues i=2(1)3665 {
quietly append using ttt`i'
quietly erase ttt`i'.dta
}

save TTT_PreTot_2000_2008_WindowTot, replace



**************************************************************************************************************
**************************************************************************************************************
**************************************************************************************************************
**************************************************************************************************************
**** CEM PROCEDURE 2000-2012 SEMI-ANNUAL*****


cd D:\P_ABS\Stata
use Final_Panel, clear
bysort eid: egen sum1=sum(CitesUKNet)
drop if sum1==0
keep if sum1<100
keep eid  year citingyear winner  CitesUKNet
reshape wide CitesUKNet, i(eid) j(citingyear)
forvalues i=1993(1)2018 {
replace CitesUKNet`i' = 0 if CitesUKNet`i' ==.
}
gen CITES1 		= CitesUKNet2000+ CitesUKNet2001+CitesUKNet2002
gen CITES2 		= CitesUKNet2003+CitesUKNet2004
gen CITES3 		= CitesUKNet2005+CitesUKNet2006
gen CITES4 		= CitesUKNet2007+CitesUKNet2008
gen CITES5		= CitesUKNet2009+CitesUKNet2010
gen CITES6		= CitesUKNet2011+CitesUKNet2012
sort winner eid
bysort winner: gen jj=_n
bysort winner: sum jj
codebook eid if winner==1
sum CITES*, de
save TTTEMP, replace


forvalues i=1(1)3665 {
quietly use TTTEMP, clear
quietly keep if (winner==1 & jj==`i') | winner==0
gen y1 =year if winner==1
egen y2=min(y1)
keep if y2==year
drop y1 y2
quietly cem   CITES1 (0 0.01 1 2 4)  CITES2 (0 0.01 1 2 4)  CITES3 (0 0.01 1 2 4) CITES4 (0 0.01 1 2 4) CITES5 (0 0.01 1 2 4) CITES6 (0 0.01 1 2 4) , treatment(winner)   k2k
quietly keep if cem_matched==1
drop cem_str cem_weigh jj 
reshape long CitesUKNet, i(eid) j(citingyear)
keep if citingyear>=year
gen KK=`i'
quietly save ttt`i', replace
}

use ttt1, clear
quietly forvalues i=2(1)3665 {
quietly append using ttt`i'
quietly erase ttt`i'.dta
}

save TTT_2000_2012_SemiAnnual, replace
