* From the R-code, you will be able to acquire the following .csv files:
/*
1) x.journal.items 			where x stands for issn (journal)
2) x.citing.items.affil		where x stands for issn (journal)
3) journal_items_authors_ids.csv
4) all_citing_items_author_ids.csv
*/

/* By running first the ancillary files starting with 0_ and then this Master File you will be able to get a panel of papers along with
Several citation measures. Note, that the initial data compilation included papers earlier than 2000 and from other journals. 
So, in the next do file, we drop these additional papers. However, the results are qualitatively similar when including papers from these journals 
even before 2000.*/




/*
*import journal_items_authors_ids.csv, stringcols(_all) clear
*save journal_items_authors_ids, replace
use journal_items_authors_ids, clear
drop author_name
bysort item_eid author_id: gen nn=_n
keep if nn==1
drop nn
bysort item_eid: gen n=_n
ta n
reshape wide author_id, i(item) j(n)
rename item_eid eid
sort eid
save SelfCites_EID, replace
******************************
******************************
******************************
*import all_citing_items_author_ids.csv, stringcols(_all) clear
*save all_citing_items_author_ids, replace
use all_citing_items_author_ids, clear
drop author_name
bysort citing_item_eid author_id: gen nn=_n
keep if nn==1
drop nn
bysort citing_item_eid: gen n=_n
ta n
rename author_id citing_author_id
reshape wide citing_author_id, i(citing_item_eid) j(n)
rename citing_item_eid citingeid
sort citingeid
save SelfCites_CitingEID, replace
*/

* Append all .csv files to acquire information on the focal papers.
*0003-066X
local lista "	0003-0554	0003-066X	0004-3702	0007-1315	0007-2303	0014-2921	0022-1031	0022-2186	0022-2879	0034-3404	0034-6535	0160-7383	0167-6296	0261-5177	0263-7758	0304-3878	0305-750X	0743-0167	0894-3796	0960-1627	0960-6491	0963-1798	1045-2354	1045-3172	1053-1858	1057-7408"
import delimited using 0001-8791.journal.items.csv, stringcols(_all) clear
gen issn="0001-8791"
save zzz, replace 
foreach x of local lista {
quietly import delimited using `x'.journal.items.csv, stringcols(_all) clear
gen issn="`x'"
quietly append using zzz
quietly save zzz, replace
}
*keep if subtypedescription=="Article"
gen year =real(substr(prismcoverdate,1,4))
drop if year==.
bysort eid: gen nn=_n
keep if nn==1
keep prismpagerange authorcount openaccess fundno fundsponsor pubmedid eid prismpublicationname year subtypedescription issn
rename issn cited_issn

gen p1 = real(substr(prismpagerange,1,strpos(prismpagerange,"-")-1))
gen p2 = real(substr(prismpagerange,strpos(prismpagerange,"-")+1,99))
order p2
order p1 prismpagerange
gen Pages = p2-p1
drop p2 p1 prismpagerange

gen 		Funding1 = 0 if fundno=="undefined"
replace 	Funding1 = 1 if Funding1 ==.

gen 		Funding2 = 0 if fundsponsor=="NA"
replace 	Funding2 = 0 if fundsponsor ==""
replace 	Funding2 = 1 if Funding1 ==.
drop fundsponsor fundno

gen 	PubMed = 1 if real(pubme)~=.
replace PubMed = 0 if PubMed ==.
drop pubmed

gen NumbAuth = real(auth)
drop auth

gen OpenAcc = real(open)
drop open

drop if eid=="2-s2.0-0027339615"

sort eid
merge eid using auth_eid_info
ta _mer
drop if _mer==2
drop _merg
sort eid
save Records, replace

********************************************************************************
********************************************************************************
********************************************************************************
* Append all articles that have cited the focal papers.
local lista "	0003-0554	0003-066X	0004-3702	0007-1315	0007-2303	0014-2921	0022-1031	0022-2186	0022-2879	0034-3404	0034-6535	0160-7383	0167-6296	0261-5177	0263-7758	0304-3878	0305-750X	0743-0167	0894-3796	0960-1627	0960-6491	0963-1798	1045-2354	1045-3172	1053-1858	1057-7408"
*0001-8791
import delimited using 0001-8791.citing.items.affil.csv, stringcols(_all) clear
save zzz, replace 
foreach x of local lista {
quietly import delimited using `x'.citing.items.affil.csv, stringcols(_all) clear
quietly append using zzz
quietly save zzz, replace
}


use zzz, clear
gen uk = 1 if country=="United Kingdom"
bysort citingeid journaleid: egen UK =  sum(uk)
bysort citingeid journaleid: gen N= _N
gen UK1 = 1 if UK==N & UK~=. & UK~=0 & N~=. & N~=0
gen AtLeastUK = 1 if UK>0 & UK~=.
replace AtLeastUK=0 if AtLeastUK==.
gen 	us = 1 if country=="United States"
bysort citingeid journaleid: egen US =  sum(us)
gen AllUS=1 if US==N & US~=. & US~=0 & N~=. & N~=0
drop US
drop N UK uk
rename UK1 UK


bysort citingeid journaleid: gen nn=_n
keep if nn==1
rename journaleid eid
gen citingyear = real(year)
drop if citingyear==.
keep eid citingeid citingyear UK AtLeastUK AllUS issn type
rename type citingtype
drop if eid=="2-s2.0-0001605514"
drop if eid=="2-s2.0-0027339615"
**************
**************
**************
sort eid
merge eid using Records
ta _m
drop if _m==1
drop _m
**************
**************
**************

* The initial data collection included journals that were eventually used as they did not fit the criteria outlined in the paper.
ta prismpublicationname
replace prismpublicationname ="Journal of Health Economics" if prismpublicationname =="Journal of health economics"
replace prismpublicationname ="British Journal of Sociology" if prismpublicationname =="The British journal of sociology"
replace prismpublicationname ="American Political Science Review" if prismpublicationname =="The American political science review."
replace prismpublicationname ="American Political Science Review" if prismpublicationname =="The American political science review."
replace prismpublicationname ="Journal of Organizational Behavior" if prismpublicationname =="Journal of organizational Behavior"
replace prismpublicationname ="American Psychologist" if prismpublicationname =="The American psychologist"
ta prismpublicationname


gen unrelated=.
replace unrelated= 2 if prismpublicationname =="Artificial Intelligence"
replace unrelated = 2 if prismpublicationname =="American Psychologist"
replace unrelated = 2 if prismpublicationname =="The American political science review"
replace unrelated = 2 if prismpublicationname =="American Political Science Review"
replace unrelated = 2 if prismpublicationname =="The American political science review."
drop if unrelated==2
drop if prismpublicationname=="NA"
codebook eid
keep if subtypedescription=="Article"
codebook eid
drop unrelated




gen 	winner = 1 if prismpublicationname =="British Journal of Management"
replace	winner = 1 if prismpublicationname =="Annals of Tourism Research"
replace	winner = 1 if prismpublicationname =="Journal of Vocational Behavior"
replace	winner = 1 if prismpublicationname =="Environment and Planning D: Society and Space"
replace winner = 1 if prismpublicationname =="Journal of Consumer Psychology"
replace winner = 1 if prismpublicationname =="Journal of Experimental Social Psychology"
replace winner = 1 if prismpublicationname =="Journal of Money, Credit and Banking"
replace winner = 1 if prismpublicationname =="Journal of Occupational and Organizational Psychology"
replace winner = 1 if prismpublicationname =="Journal of Organizational Behavior"
replace winner = 1 if prismpublicationname =="Journal of Public Administration Research and Theory"
replace winner = 1 if prismpublicationname =="Journal of Vocational Behavior"
replace winner = 1 if prismpublicationname =="Review of Economics and Statistics"
replace winner = 1 if prismpublicationname =="Tourism Management"

replace winner = 0 if prismpublicationname =="British Journal of Sociology"
replace winner = 0 if prismpublicationname =="The British journal of sociology"
replace winner = 0 if prismpublicationname =="Brookings Papers on Economic Activity"
replace winner = 0 if prismpublicationname =="Critical Perspectives on Accounting"
replace winner = 0 if prismpublicationname =="European Economic Review"
replace winner = 0 if prismpublicationname =="Industrial and Corporate Change"
replace winner = 0 if prismpublicationname =="Journal of Development Economics"
replace winner = 0 if prismpublicationname =="Journal of Health Economics"
replace winner = 0 if prismpublicationname =="Journal of Law and Economics"
replace winner = 0 if prismpublicationname =="Journal of health economics"
replace winner = 0 if prismpublicationname =="Journal of Rural Studies"
replace winner = 0 if prismpublicationname =="Mathematical Finance"
replace winner = 0 if prismpublicationname =="Regional Studies"
replace winner = 0 if prismpublicationname =="World Development"


ta prismpublicationname if winner==.

*drop if prismpublicationname =="British Journal of Sociology"
bysort prismpublicationname: gen N=_N
ta prismpublicationname if N<1000
drop if N<1000

gen period = citingyear -year

******
sort eid citingeid
merge eid citingeid using CitingAffInfor
ta _mer
drop if _mer==2
drop _mer
******


******
rename eid journaleid
sort journaleid citingeid
merge journaleid citingeid using ISSN_Journals
rename journaleid eid
ta _mer
drop if _mer==2
drop _mer
******


************************************************
************************************************
************************************************
************************************************
codebook eid
* Get Info on Author IDs both for focal papers and citing papers
sort eid
merge eid using SelfCites_EID
ta _mer
drop if _merg==2
drop _merg
codebook eid

sort citingeid
merge citingeid using SelfCites_CitingEID
ta _mer
drop if _mer==2
codebook eid

gen sss = 0 
forvalues i=1(1)45 {
forvalues j=1(1)100 {
quietly replace sss =1 if author_id`i'==citing_author_id`j' & author_id`i'~="" & citing_author_id`j'~=""
}
}
rename sss author_self_cite
drop citing_author_id* author_id*
************************************************
************************************************
************************************************
************************************************

***********
***********
***********
*bysort issn: gen NN=_N
*drop if  abs2010_==0 & NN>500
***********
***********
***********
replace issn 		= subinstr(issn,"-","",.)
replace cited_issn 	= subinstr(cited_issn,"-","",.)
gen selfcite 		= 1 if issn==cited_issn & issn~="" 
replace selfcite=0 if selfcite ==.
replace author_self_cite=0 if author_self_cite==.

ta selfcite author_self

save zz, replace
save zzyytt1, replace
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
use zzyytt1, clear
drop _mer
sort eid citingeid
merge eid citingeid using SelfIstitutionCites
ta _merg
drop if _merg==2
drop _merg
replace self_inst = 0 if self_inst==.
ta self_ins

gen top 	= 1 if UK==1 & max1<20 & max1~=. & selfcite==0 & author_self_cite==0 
gen middle 	= 1 if UK==1 & max1>=20 & max1<50 & max~=. & selfcite==0 & author_self_cite==0 
gen middle1 = 1 if UK==1 & max1>=20 & max1<50 & min1>=20  & max~=. & selfcite==0 & author_self_cite==0 
drop middle
rename middle1 middle
gen low 	= 1 if UK==1 & min1>=50 & max1>=50  & selfcite==0 & author_self_cite==0 

bysort eid period: gen  Cites 			= _N
bysort eid period: egen CitesUK 		= sum(UK)
bysort eid period: egen CitesAtLeastUK 	= sum(AtLeastUK)
bysort eid period: egen CitesAllUS 		= sum(AllUS)

gen 	iii = 1 
replace iii = 0 if selfcite==1 | author_self_cite==1
gen UK_Net			= 1 if UK==1 		& selfcite==0 & author_self_cite==0 
gen AtLeastUKNet	= 1 if AtLeastUK==1 & selfcite==0 & author_self_cite==0 
gen AllUSNet		= 1 if AllUS==1 	& selfcite==0 & author_self_cite==0 
bysort eid period: egen CitesNet			= sum(iii)
bysort eid period: egen CitesUKNet 			= sum(UK_Net)
bysort eid period: egen CitesUKTopNet 		= sum(top)
bysort eid period: egen CitesUKMiddleNet 		= sum(middle)
bysort eid period: egen CitesUKLowNet 		= sum(low)
bysort eid period: egen CitesAtLeastUKNet 	= sum(AtLeastUKNet)
bysort eid period: egen CitesAllUSNet 		= sum(AllUSNet)


gen UK_Grade4			= 1 if UK==1 		& gr4==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen UKTop_Grade4		= 1 if top==1 		& gr4==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen AtLeastUK_Grade4	= 1 if AtLeastUK==1 & gr4==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen AllUS_Grade4		= 1 if AllUS==1 	& gr4==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
bysort eid period: egen CitesGrade4 = sum(gr4)
bysort eid period: egen CitesUKGrade4 = sum(UK_Grade4)
bysort eid period: egen CitesUKTopGrade4 = sum(UKTop_Grade4)
bysort eid period: egen CitesAtLeastUKGrade4 = sum(AtLeastUK_Grade4)
bysort eid period: egen CitesAllUSGrade4 = sum(AllUS_Grade4)

gen book = 1 if abs2010==0 & strpos(citingtype,"Book")>0
gen UK_Book				= 1 if UK==1 		& book==1 & selfcite==0 & author_self_cite==0
gen AtLeastUK_Book		= 1 if AtLeastUK==1 & book==1 & selfcite==0 & author_self_cite==0 
gen AllUS_Book			= 1 if AllUS==1 	& book==1 & selfcite==0 & author_self_cite==0 
bysort eid period: egen CitesBook = sum(book)
bysort eid period: egen CitesUKBook = sum(UK_Book)
bysort eid period: egen CitesAtLeastUKBook= sum(AtLeastUK_Book)
bysort eid period: egen CitesAllUSBook= sum(AllUS_Book)

gen UK_abs			= 1 if UK==1 		& abs2010_==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen AtLeastUK_abs	= 1 if AtLeastUK==1 & abs2010_==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen AllUS_abs		= 1 if AllUS==1 	& abs2010_==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
bysort eid period: egen CitesABS = sum(abs2010_)
bysort eid period: egen CitesUKABS = sum(UK_abs )
bysort eid period: egen CitesAtLeastUKABS  = sum(AtLeastUK_abs )
bysort eid period: egen CitesAllUSABS  = sum(AllUS_abs )

gen gr34 				= 1 if gr3==1 | gr4==1
gen UK_Grade34			= 1 if UK==1 		& gr34==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen AtLeastUK_Grade34	= 1 if AtLeastUK==1 & gr34==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen AllUS_Grade34		= 1 if AllUS==1 	& gr34==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
bysort eid period: egen CitesGrade34 = sum(gr34)
bysort eid period: egen CitesUKGrade34 = sum(UK_Grade34)
bysort eid period: egen CitesAtLeastUKGrade34 = sum(AtLeastUK_Grade34)
bysort eid period: egen CitesAllUSGrade34 = sum(AllUS_Grade34)
gen alt=1 if  issn~="NA" & UK==1 		& selfcite==0
bysort eid period: egen CitesAltUK = sum(alt)
 
gen NonABSSnip5		= 1 if UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0 & IF_snip<0.5
gen NonABSSnip15		= 1 if UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0 & IF_snip>=0.5 & IF_snip<1.5
gen NonABSSnip100		= 1 if UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0 & IF_snip>=1.5
bysort eid period: egen CitesNonABSSnip5 = sum(NonABSSnip5)
bysort eid period: egen CitesUKNonABSSnip15 = sum(NonABSSnip15)
bysort eid period: egen CitesUKNonABSSnip100 = sum(NonABSSnip100)


* Create Mix of University-Grade34 and nonABS
gen UKLow_Grade34		= 1 if low==1 		& gr34==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen UKMiddle_Grade34	= 1 if middle==1 		& gr34==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen UKTop_Grade34		= 1 if top==1 		& gr34==1 & selfcite==0 & author_self_cite==0 & issn~="NA"

gen UKLow_Book			= 1 if low==1 		& book==1 & selfcite==0 & author_self_cite==0 
gen UKMiddle_Book		= 1 if middle==1 	& book==1 & selfcite==0 & author_self_cite==0 
gen UKTop_Book			= 1 if top==1 		& book==1 & selfcite==0 & author_self_cite==0 

gen UKLow_ABS		= 1 if low==1 		& abs2010_==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen UKMiddle_ABS	= 1 if middle==1 		& abs2010_==1 & selfcite==0 & author_self_cite==0 & issn~="NA"
gen UKTop_ABS		= 1 if top==1 		& abs2010_==1 & selfcite==0 & author_self_cite==0 & issn~="NA"



gen UKLow_NonABS15 		= 1 if low==1 		& 	UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0
gen UKMiddle_NonABS15 	= 1 if middle==1	& 	UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0
gen UKTop_NonABS15 		= 1 if top==1 		& 	UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0
gen UKNonABS15 			= 1 if 					UK==1 		& selfcite==0 & author_self_cite==0 & issn~="NA" & strpos(citingtype,"Book")==0 & abs2015_==0 & abs2010_==0
bysort eid period: egen CitesUKNonABS15 = sum(UKNonABS15)
bysort eid period: egen CitesUKLowNonABS15 = sum(UKLow_NonABS15)
bysort eid period: egen CitesUKMiddleNonABS15 = sum(UKMiddle_NonABS15)
bysort eid period: egen CitesUKTopNonABS15 = sum(UKTop_NonABS15)



gen UKLow_NonABS15B 		= 1 if low==1 		& 	UK==1 		& selfcite==0 & author_self_cite==0  & abs2015_==0 & abs2010_==0
gen UKMiddle_NonABS15B 		= 1 if middle==1	& 	UK==1 		& selfcite==0 & author_self_cite==0  & abs2015_==0 & abs2010_==0
gen UKTop_NonABS15B 		= 1 if top==1 		& 	UK==1 		& selfcite==0 & author_self_cite==0  & abs2015_==0 & abs2010_==0
gen UKNonABS15B 			= 1 if 					UK==1 		& selfcite==0 & author_self_cite==0  & abs2015_==0 & abs2010_==0
bysort eid period: egen CitesUKNonABS15B 		= sum(UKNonABS15B)
bysort eid period: egen CitesUKLowNonABS15B 	= sum(UKLow_NonABS15B)
bysort eid period: egen CitesUKMiddleNonABS15B 	= sum(UKMiddle_NonABS15B)
bysort eid period: egen CitesUKTopNonABS15B 	= sum(UKTop_NonABS15B)





bysort eid period: egen CitesUKLowGrade34 = sum(UKLow_Grade34)
bysort eid period: egen CitesUKMiddleGrade34 = sum(UKMiddle_Grade34)
bysort eid period: egen CitesUKTopGrade34 = sum(UKTop_Grade34)

bysort eid period: egen CitesUKLowBook = sum(UKLow_Book)
bysort eid period: egen CitesUKMiddleBook = sum(UKMiddle_Book)
bysort eid period: egen CitesUKTopBook = sum(UKTop_Book)

bysort eid period: egen CitesUKLowABS = sum(UKLow_ABS)
bysort eid period: egen CitesUKMiddleABS = sum(UKMiddle_ABS)
bysort eid period: egen CitesUKTopABS = sum(UKTop_ABS)

*keep if period>=0 & period<30
keep eid period year Cites* winner prismpublicationname Pages Funding1 Funding2 PubMed NumbAuth OpenAcc Max* NumbAuthors
save bala_, replace
sort Cites


use bala_, clear
bysort eid: gen nn=_n
keep if nn==1
keep eid 
gen period =0
save bala, replace

forvalues i=1(1)26 {
bysort eid: gen nn=_n
keep if nn==1
keep eid 
gen period =`i'
append using bala
sort eid period
save bala, replace
}

use bala_, clear
bysort eid period: gen nn=_n
keep if nn==1
keep eid period Cites*
sort eid period
merge eid period using bala
ta _me
drop if _m==1
drop _m
save bala, replace

use bala_, clear
keep eid prismpublicationname year winner Pages Funding1 Funding2 PubMed NumbAuth OpenAcc Max* NumbAuthors
bysort eid: gen hh=_n
keep if hh==1
drop hh
sort eid
save eids, replace



clear all
set maxvar 11000
set mat 11000
use bala, clear
sort eid
merge eid using eids
ta _m
keep if period<=2018-year
drop _m


local lista "Cites CitesUK CitesAtLeastUK CitesAllUS       CitesGrade4 CitesUKGrade4 CitesUKTopGrade4 CitesAtLeastUKGrade4 CitesAllUSGrade4 CitesGrade34 CitesUKGrade34 CitesUKTopGrade34 CitesAtLeastUKGrade34 CitesAllUSGrade34 CitesABS CitesUKABS  CitesUKTopABS   CitesAtLeastUKABS CitesAllUSABS CitesAltUK CitesBook CitesUKBook  CitesUKTopBook CitesAtLeastUKBook CitesAllUSBook CitesNet CitesUKNet CitesUKTopNet CitesAtLeastUKNet CitesAllUSNet CitesUKMiddleNet CitesUKLowNet CitesUKNonABS15 CitesUKLowNonABS15 CitesUKMiddleNonABS15 CitesUKTopNonABS15 CitesUKLowGrade34 CitesUKMiddleGrade34 CitesUKTopGrade34 CitesUKLowBook CitesUKMiddleBook CitesUKTopBook CitesUKLowABS CitesUKMiddleABS CitesUKTopABS CitesUKNonABS15B CitesUKLowNonABS15B CitesUKMiddleNonABS15B CitesUKTopNonABS15B CitesNonABSSnip5 CitesUKNonABSSnip15 CitesUKNonABSSnip100"
foreach x of loca lista {
replace `x'=0 if `x'==.
}
drop if winner==2
keep if year<2004
gen citingyear = year+period
sort eid period
save Final_Panel_Baseline1, replace
