*0003-066X
local lista "	0003-0554	0003-066X	0004-3702	0007-1315	0007-2303	0014-2921	0022-1031	0022-2186	0022-2879	0034-3404	0034-6535	0160-7383	0167-6296	0261-5177	0263-7758	0304-3878	0305-750X	0743-0167	0894-3796	0960-1627	0960-6491	0963-1798	1045-2354	1045-3172	1053-1858	1057-7408"
import delimited using 0001-8791.journal.items.csv, stringcols(_all) clear
save zzz, replace 
foreach x of local lista {
quietly import delimited using `x'.journal.items.csv, stringcols(_all) clear
quietly append using zzz
quietly save zzz, replace
}
*keep if subtypedescription=="Article"
gen year =real(substr(prismcoverdate,1,4))
drop if year==.
bysort eid: gen nn=_n
keep if nn==1
keep prismpagerange authorcount openaccess fundno fundsponsor pubmedid eid prismpublicationname year subtypedescription

gen p1 = real(substr(prismpagerange,1,strpos(prismpagerange,"-")-1))
gen p2 = real(substr(prismpagerange,strpos(prismpagerange,"-")+1,99))
order p2
order p1 prismpagerange
gen Pages = p2-p1
drop p2 p1 prismpagerange

gen 		Funding1 = 0 if fundno=="undefined"
replace 	Funding1 = 1 if Funding1 ==.

gen 		Funding2 = 0 if fundsponsor=="NA"
replace 	Funding2 = 0 if fundsponsor ==""
replace 	Funding2 = 1 if Funding1 ==.
drop fundsponsor fundno

gen 	PubMed = 1 if real(pubme)~=.
replace PubMed = 0 if PubMed ==.
drop pubmed

gen NumbAuth = real(auth)
drop auth

gen OpenAcc = real(open)
drop open

drop if eid=="2-s2.0-0027339615"

sort eid
save Records_Affil, replace
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
local lista "	0003-0554	0003-066X	0004-3702	0007-1315	0007-2303	0014-2921	0022-1031	0022-2186	0022-2879	0034-3404	0034-6535	0160-7383	0167-6296	0261-5177	0263-7758	0304-3878	0305-750X	0743-0167	0894-3796	0960-1627	0960-6491	0963-1798	1045-2354	1045-3172	1053-1858	1057-7408"
*0001-8791
import delimited using 0001-8791.citing.items.affil.csv, stringcols(_all) clear
save zzz, replace 
foreach x of local lista {
quietly import delimited using `x'.citing.items.affil.csv, stringcols(_all) clear
quietly append using zzz
quietly save zzz, replace
}
keep if country=="United Kingdom"


gen			Grade = 1 if affil == "London School of Economics and Political Science"
replace		Grade = 2 if affil == "University of Cambridge"
replace		Grade = 3 if affil == "Imperial College London"
replace		Grade = 4 if strpos(affil,"University of Oxford")>0
replace		Grade = 5 if affil == "London Business School"
replace		Grade = 5 if affil == "LBS"
replace		Grade = 6 if affil == "Cardiff University"
replace		Grade = 7 if affil == "City University London"
replace		Grade = 7 if affil == "City, University of London"
replace		Grade = 8 if affil == "University of Bath"
replace		Grade = 9 if affil == "University of Leeds"
replace		Grade = 10 if affil == "University of Strathclyde"
replace		Grade = 11 if affil == "University of Lancaster"
replace		Grade = 11 if affil == "Lancaster University"

replace		Grade = 12 if affil == "University of Warwick"
replace		Grade = 12 if affil == "The University of Warwick"

replace		Grade = 13 if strpos(affil,"University of St Andrews")>0
replace		Grade = 14 if affil == "King's College London"
replace		Grade = 14 if affil == "University of Sheffield"

replace		Grade = 16 if affil == "University of Reading"
replace		Grade = 17 if affil == "University of East Anglia"
replace		Grade = 18 if affil == "University of Manchester"
replace		Grade = 18 if affil == "Aston University"
replace		Grade = 20 if affil == "University of Durham"
replace		Grade = 21 if affil == "University of Edinburgh"

replace		Grade = 22 if affil == "Cranfield University"
replace		Grade = 22 if affil == "University Cranfield"
replace		Grade = 22 if affil == "UCL"
replace		Grade = 24 if affil == "University of Bristol"
replace		Grade = 24 if affil == "University of Aberdeen"
replace		Grade = 26 if affil == "Loughborough University"
replace		Grade = 26 if affil == "University of Stirling"
replace		Grade = 26 if affil == "Ulster University"
replace		Grade = 29 if affil == "Royal Holloway University of London"
replace		Grade = 29 if affil == "Royal Holloway University of London"
replace		Grade = 30 if affil == "Swansea University"
replace		Grade = 31 if affil ==  "University of Nottingham"
replace		Grade = 31 if affil ==  "University of Liverpool"
replace		Grade = 33 if affil ==  "University of Southampton"
replace		Grade = 34 if affil ==  "Queen's University Belfast"
replace		Grade = 34 if affil ==  "Open University"
replace		Grade = 36 if affil ==  "University of Sussex"
replace		Grade = 36 if affil ==  "University of York"
replace		Grade = 38 if affil ==  "University of Essex"
replace		Grade = 39 if affil ==  "University of Exeter"
replace		Grade = 39 if affil ==  "Queen Mary, University of London"
replace		Grade = 41 if affil ==  "University of Birmingham"
replace		Grade = 41 if affil ==  "University of Kent"
replace		Grade = 41 if affil ==  "University of Brighton"
replace		Grade = 44 if affil ==  "University of Bradford"
replace		Grade = 45 if affil ==  "University of Glasgow"
replace		Grade = 45 if affil ==  "Bangor University"
replace		Grade = 47 if affil ==  "Kingston University"
replace		Grade = 48 if affil ==  "Heriot-Watt University, Edinburgh"
replace		Grade = 49 if affil ==  "University of Portsmouth"
replace		Grade = 49 if affil ==  "De Montfort"

bysort affil: gen N=_N
ta affi if N>500 & Grade==.
ta affil if strpos(affil, "Swansea")>0

replace Grade=99 if Grade==.
bysort citingeid journaleid: egen max1 = max(Grade)
bysort citingeid journaleid: egen min1 = min(Grade)
bysort citingeid journaleid: gen nn=_n
keep if nn==1
keep journalei citingeid max* min*
rename journaleid eid
sort eid citingeid
save CitingAffInfor, replace



